

//-----------------------------------------------------------------------------
// Name: class CXBoxSample
// Desc: Main class to run this application. Most functionality is inherited
//       from the CXBApplication base class.
//-----------------------------------------------------------------------------
class CXBoxSample 
{

public:
    HRESULT LoadWaveBank( LPCSTR strFilename );             // Load a wave bank
    HRESULT InitializeBufferPool( DWORD dwNumberOfBuffers,  // Initialize our buffer pool
                                  VOID* pbSampleData, 
                                  DWORD dwDataLength );
    HRESULT PlaySound( DWORD dwIndex, BOOL fLooping );      // Play the specified sound

    BufferQueueNode* Dequeue();                             // Dequeue from buffer pool
    VOID             Enqueue( BufferQueueNode* pNode );     // Enqueue to buffer pool

    //CXBFont     m_Font;                                     // Font object
    //CXBHelp     m_Help;                                     // Help object
    BOOL        m_bDrawHelp;                                // TRUE to draw help screen

    LPDIRECTSOUND       m_pDSound;                          // DirectSound object

    DWORD               m_dwDisplayStart;                   // Display management
    DWORD               m_dwSelection;                      // ...
    DWORD               m_dwCurrent;                        // ...

    // Wave bank entries and sample data
    WAVEBANKENTRY       m_aWaveBankEntries[XACT_WAVEBANK_SOUNDS_ENTRY_COUNT];
    BYTE*               m_pbSampleData;
    DWORD               m_dwWaveNameSize;
    BYTE*               m_pbWaveNames;

    BufferQueueNode*    m_pNodes;                           // Buffer Queue allocation
    DWORD               m_dwNumberOfBuffers;                // Total # of buffers
    DWORD               m_dwAvailableBuffers;               // # of available buffers
    DWORD               m_dwPlayingBuffers;                 // # of playing buffers
    BufferQueueNode*    m_pBufferPoolHead;                  // Queue of ready buffers
    BufferQueueNode*    m_pBufferPoolTail;                  // ...

    BufferQueueNode*    m_pBusyBuffersHead;                 // List of busy buffers

public:
    virtual HRESULT Initialize();
    virtual HRESULT Render();
    virtual HRESULT FrameMove();

    CXBoxSample();
};

CXBoxSample soundFX;